local assets =
{
    Asset("ANIM", "anim/moonghost.zip"),
    Asset("SOUND", "sound/hound.fsb"),
	Asset("MINIMAP_IMAGE", "hound_mound"),
}

local prefabs =
{
"monster",
}

SetSharedLootTable('moonghost',
{
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
	{'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
	{'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
	{'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'earlkeith', 1.00},
    {'redgem',      0.5},
    {'bluegem',     0.5},
})



local function OnKilled(inst)
    inst.AnimState:PlayAnimation("death", false)
    inst.SoundEmitter:KillSound("loop")
    inst.components.lootdropper:DropLoot(inst:GetPosition())
end
local function OnAttacked(inst, data)
    inst.components.combat:ShareTarget(data.attacker, 300, function(dude) return dude:HasTag("moonmonster") and not dude.components.health:IsDead() end, 5)
end
local function SpawnAllGuards(inst, attacker)
    if not inst.components.health:IsDead()  then
        inst.AnimState:PlayAnimation("hit")
        inst.AnimState:PushAnimation("idle", false)
        
    end
end
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst, .5)

    inst.MiniMapEntity:SetIcon("hound_mound.png")

    inst.AnimState:SetBank("moonghost")
    inst.AnimState:SetBuild("moonghost")
    inst.AnimState:PlayAnimation("idle",true)

    inst:AddTag("structure")
    inst:AddTag("chewable") -- by werebeaver
    inst:AddTag("moonmonster")

    MakeSnowCoveredPristine(inst)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    -------------------
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(1000)
    inst:ListenForEvent("death", OnKilled)

    -------------------
    ---------------------
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('moonghost')
	inst:ListenForEvent("attacked", OnAttacked)

    ---------------------
    inst:AddComponent("inspectable")
    inst.OnEntitySleep = OnEntitySleep
    inst.OnEntityWake = OnEntityWake
    MakeSnowCovered(inst)
	inst:AddComponent("combat")
    inst.components.combat:SetOnHit(SpawnAllGuards)
	inst.Transform:SetScale(5, 5, 5)
	inst:DoPeriodicTask(120, function(inst)
	 local x, y, z = inst.Transform:GetWorldPosition()
	local xxx = math.random(-5,5)
	local zzz = math.random(-5,5)
	SpawnPrefab("moonmonster").Transform:SetPosition(x, y, z)
	 end)

    return inst
end

return Prefab("moonghost", fn, assets, prefabs)
